# How to use the ClamXAV Remote Deployment tool


1. Install ClamXAV on a local/test computer.

2. Install the registration key and set up your preferences as desired.

3. Copy the following items into their respective locations in the `RemoteHD` folder structure:
```
	/Applications/ClamXAV.app
	/Library/Application Support/ClamXAV/Settings/
```

## Specifying default preference settings
If you don't want to specify default preferences, go directly to step 6.

4. Copy the file in `/Library/Application Support/ClamXAV/Settings/Users` to the same place within the `RemoteHD` folder, but change the name to the login user name on the target computer.

5. If you also want to prevent your users from modifying your default preferences, take that plist file, rename it to override.plist and move it up one level so that it's sitting in `RemoteHD/Library/Application Support/ClamXAV/Settings/` also see the section below called "Overriding/enforcing preference settings"


## Notifying a designated email contact upon malware detection

As of ClamXAV 3.4, it can now notify a designated email contact upon malware detection on any of your endpoints. To enable this, you need to deploy a `global.plist` preferences file to your endpoints.

You can find an example of this in `RemoteDeploymentTool/Extras/global.plist`. You'll need to change the value of the `SendEmailAlert` setting to `true`. You will also need to email support@clamxav.com and let our support staff know the email address to be notified when malware is detected.

The `global.plist` file should be copied to `RemoteHD/Library/Application Support/ClamXAV/Settings/global.plist`


## Configuration Profile for Full Disk Access

You may also need to distribute a configuration profile to your Macs to enable Full Disk Access. If you don't do this, you will need to manually enable this via System Preferences on each computer. You can find the profile in the Extras folder, called `ClamXAV Full Disk Access.mobileconfig`


## Overriding/enforcing preference settings

You can force any preference setting with an override config file.

Alongside this Read Me file, you'll find a sample override configuration file. It's an XML file but it can be edited with a plain text editor. The first two settings will ensure the database is updated daily and that the app itself will be kept up-to-date:

```
	ScheduleUpdateFrequency	1
	UpdateClamXAVOnLaunch	true
```
The file then configures a default set of preferences for the scan settings.

After that is a section which lists the preference settings that users are allowed to specify for themselves - `UserConfigurableSettings`.

For the purposes of this example, you'll want to remove the lines in this section which would otherwise allow users to configure `ScheduleUpdateFrequency` and `UpdateClamXAVOnLaunch` via the app.

The `override.plist` file should be placed within RemoteHD/Library/Application Support/ClamXAV/Settings/ _prior_ to generating the ClamXAV.pkg installer file in step 6 below.


## Generate the ClamXAV.pkg installer package
6. Open a terminal window into the `RemoteDeploymentTool` folder and run the `buildStandaloneInstaller.sh` script.


That will result in a package file called `ClamXAV.pkg` which you should to be able to deploy via your usual tools.
